#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#define ITERACIJE 100

typedef struct {
    long long x, y;
    int index;
} Vektor;

void resavaj(int N, Vektor *vektori, double Dx, double Dy, long long *max_kvadrat, int *izabrano_best, int *izabrano_temp);

int main() {
    srand(time(NULL));

    int N;
    if (scanf("%d", &N) != 1 || N < 1) return 1;

    Vektor *vektori = (Vektor *)malloc(N * sizeof(Vektor));
    int *izabrano_best = (int *)calloc(N, sizeof(int));
    int *izabrano_temp = (int *)calloc(N, sizeof(int));
    
    if (vektori == NULL || izabrano_best == NULL || izabrano_temp == NULL) {
        free(vektori); free(izabrano_best); free(izabrano_temp);
        return 1;
    }

    for (int i = 0; i < N; i++) {
        if (scanf("%lld %lld", &vektori[i].x, &vektori[i].y) != 2) {
            free(vektori); free(izabrano_best); free(izabrano_temp);
            return 1;
        }
        vektori[i].index = i + 1;
    }

    long long max_kvadrat = -1;

    resavaj(N, vektori, 1.0, 0.0, &max_kvadrat, izabrano_best, izabrano_temp);
    resavaj(N, vektori, 0.0, 1.0, &max_kvadrat, izabrano_best, izabrano_temp);
    resavaj(N, vektori, -1.0, 0.0, &max_kvadrat, izabrano_best, izabrano_temp);
    resavaj(N, vektori, 0.0, -1.0, &max_kvadrat, izabrano_best, izabrano_temp);
    
    for (int iter = 0; iter < ITERACIJE; iter++) {
        double theta = ((double)rand() / RAND_MAX) * 2.0 * M_PI;
        double Dx = cos(theta);
        double Dy = sin(theta);
        resavaj(N, vektori, Dx, Dy, &max_kvadrat, izabrano_best, izabrano_temp);
    }
    
    int k = 0;
    for (int i = 0; i < N; i++) {
        if (izabrano_best[i]) {
            k++;
        }
    }

    printf("%d\n", k);
    
    int prvi = 1;
    for (int i = 0; i < N; i++) {
        if (izabrano_best[i]) {
            if (!prvi) {
                printf(" ");
            }
            printf("%d", vektori[i].index);
            prvi = 0;
        }
    }
    if (k > 0) {
        printf("\n");
    }

    free(vektori); 
    free(izabrano_best);
    free(izabrano_temp);

    return 0;
}

void resavaj(int N, Vektor *vektori, double Dx, double Dy, long long *max_kvadrat, int *izabrano_best, int *izabrano_temp) {
    long long Rx = 0;
    long long Ry = 0;
    
    for (int i = 0; i < N; i++) {
        if ((double)vektori[i].x * Dx + (double)vektori[i].y * Dy > 0) {
            Rx += vektori[i].x;
            Ry += vektori[i].y;
            izabrano_temp[i] = 1;
        } else {
            izabrano_temp[i] = 0;
        }
    }

    long long novi_kvad = Rx * Rx + Ry * Ry;

    if (novi_kvad > *max_kvadrat) {
        *max_kvadrat = novi_kvad;
        for (int i = 0; i < N; i++) {
            izabrano_best[i] = izabrano_temp[i];
        }
    }
}